<?php
declare(strict_types=1);

require_once __DIR__ . '/../app/core/bootstrap.php';
require_once __DIR__ . '/../app/models/CaseModel.php';
require_once __DIR__ . '/../app/models/ExpedientModel.php';

$user = require_role(['admin']);

$case_id = (int)($_GET['case_id'] ?? 0);
$case = CaseModel::find($case_id);
if (!$case) { http_response_code(404); exit('Caso no encontrado'); }

$page_title = 'Expedientes - Caso #' . $case_id;
$active = 'cases';

$expedients = ExpedientModel::listByCase($case_id);

require __DIR__ . '/../app/views/expedients/list.php';
