<?php
declare(strict_types=1);

require_once __DIR__ . '/../app/core/bootstrap.php';
require_once __DIR__ . '/../app/models/ImportModel.php';

$user = require_role(['admin']);

$id = (int)($_GET['id'] ?? 0);
$job = ImportModel::find($id);
if (!$job) { http_response_code(404); exit('Import no existe'); }

$path = __DIR__ . '/../' . ltrim((string)$job['stored_path'], '/');
$real = realpath($path);
if (!$real || !is_file($real)) { exit('CSV no encontrado'); }

[$header, $rows] = csv_read_preview($real, 12);

// clientes existentes
$clients = db()->query("SELECT id, name FROM clients ORDER BY name")->fetchAll() ?: [];
// gestores
$gestors = db()->query("SELECT id, name, email FROM users WHERE role='gestor' ORDER BY name")->fetchAll() ?: [];

$page_title = 'Mapeo CSV';
$active = 'imports';

require __DIR__ . '/../app/views/imports/map.php';
