<?php
declare(strict_types=1);

require_once __DIR__ . '/../app/core/bootstrap.php';
require_once __DIR__ . '/../app/models/ImportModel.php';

$user = require_role(['admin']);

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  csrf_verify();

  if (empty($_FILES['csv']) || (int)$_FILES['csv']['error'] !== UPLOAD_ERR_OK) {
    $err = 'Archivo inválido';
  } else {
    $orig = (string)$_FILES['csv']['name'];
    $tmp  = (string)$_FILES['csv']['tmp_name'];

    $baseDir = __DIR__ . '/../storage/imports';
    @mkdir($baseDir, 0775, true);

    $id = ImportModel::create($orig, '', (int)$user['id']);
    $dir = $baseDir . '/job_' . $id;
    @mkdir($dir, 0775, true);

    $dest = $dir . '/source.csv';
    if (!move_uploaded_file($tmp, $dest)) {
      ImportModel::setError($id, 'No se pudo mover el archivo');
      $err = 'No se pudo guardar el archivo';
    } else {
      // guardar ruta relativa
      $rel = 'storage/imports/job_' . $id . '/source.csv';
      db()->prepare("UPDATE import_jobs SET stored_path=? WHERE id=?")->execute([$rel, $id]);
      redirect_to('admin/import_map.php?id=' . $id);
    }
  }
}

$page_title = 'Nueva importación';
$active = 'imports';

require __DIR__ . '/../app/views/imports/new.php';
