<?php
declare(strict_types=1);

require_once __DIR__ . '/../app/core/bootstrap.php';
require_once __DIR__ . '/../app/models/CaseModel.php';
require_once __DIR__ . '/../app/models/PaymentModel.php';

$user = require_role(['admin']);

$case_id = (int)($_GET['case_id'] ?? 0);
$case = CaseModel::find($case_id);
if (!$case) { http_response_code(404); exit('Caso no encontrado'); }

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  csrf_verify();

  $amount = (float)($_POST['amount'] ?? 0);
  $date   = (string)($_POST['payment_date'] ?? date('Y-m-d'));
  $method = (string)($_POST['method'] ?? 'otro');
  $note   = trim((string)($_POST['note'] ?? ''));

  if ($amount <= 0) { $err = 'Monto inválido'; }
  else {
    $attach = null;
    if (!empty($_FILES['attachment'])) {
      $attach = handle_payment_attachment($case_id, $_FILES['attachment']);
    }

    PaymentModel::add([
      'case_id' => $case_id,
      'amount' => $amount,
      'payment_date' => $date,
      'method' => $method,
      'note' => $note ?: null,
      'attachment_path' => $attach,
      'created_by' => (int)$user['id'],
      'created_role' => 'admin'
    ]);

    case_recalc_status($case_id);
    redirect_to('admin/payments.php?case_id=' . $case_id);
  }
}

$page_title = 'Registrar pago - Caso #' . $case_id;
$active = 'cases';

require __DIR__ . '/../app/views/payments/add.php';
