<?php
declare(strict_types=1);

require_once __DIR__ . '/../app/core/bootstrap.php';
require_once __DIR__ . '/../app/models/CaseModel.php';
require_once __DIR__ . '/../app/models/PromiseModel.php';
require_once __DIR__ . '/../app/models/NotificationModel.php';

$user = require_role(['admin']);

$case_id = (int)($_GET['case_id'] ?? $_POST['case_id'] ?? 0);
$case = $case_id ? CaseModel::find($case_id) : null;
if (!$case) { http_response_code(404); exit('Caso no encontrado'); }

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  csrf_verify();

  $amt = (float)($_POST['promised_amount'] ?? 0);
  $date = (string)($_POST['promised_date'] ?? '');
  $note = trim((string)($_POST['note'] ?? ''));

  if ($amt <= 0 || $date === '') {
    $err = 'Monto/Fecha inválidos';
  } else {
    $pid = PromiseModel::create([
      'case_id' => $case_id,
      'promised_amount' => $amt,
      'promised_date' => $date,
      'note' => $note ?: null,
      'created_by' => (int)$user['id'],
      'created_role' => 'admin',
    ]);

    $bp = base_path();
    NotificationModel::add((int)$user['id'], "Nueva promesa (#{$pid})", "Caso #{$case_id} para {$date}", $bp.'/admin/promise_view.php?id='.$pid, 'info');

    // notificar gestor si hay asignación activa
    $st = db()->prepare("SELECT gestor_user_id FROM case_assignments WHERE case_id=? AND unassigned_at IS NULL LIMIT 1");
    $st->execute([$case_id]);
    $gid = (int)($st->fetchColumn() ?: 0);
    if ($gid > 0) {
      NotificationModel::add($gid, "Nueva promesa (#{$pid})", "Caso #{$case_id} para {$date}", $bp.'/gestor/promise_view.php?id='.$pid, 'info');
    }

    redirect_to('admin/promise_view.php?id=' . $pid);
  }
}

$page_title = 'Nueva promesa';
$active = 'promises';

require __DIR__ . '/../app/views/promises/form.php';
