<?php
declare(strict_types=1);

require_once __DIR__ . '/../app/core/bootstrap.php';
require_once __DIR__ . '/../app/models/PromiseModel.php';
require_once __DIR__ . '/../app/models/NotificationModel.php';

$user = require_role(['admin']);

$id = (int)($_GET['id'] ?? 0);
$p = PromiseModel::find($id);
if (!$p) { http_response_code(404); exit('No existe'); }

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  csrf_verify();
  $action = (string)($_POST['action'] ?? '');
  $note = trim((string)($_POST['resolve_note'] ?? ''));

  if (in_array($action, ['kept','broken','cancelled'], true)) {
    PromiseModel::resolve($id, $action, (int)$user['id'], $note ?: null);

    $bp = base_path();
    NotificationModel::add((int)$user['id'], "Promesa #{$id} actualizada", "Estado: {$action}", $bp.'/admin/promise_view.php?id='.$id, 'success');

    // notificar gestor
    $st = db()->prepare("SELECT gestor_user_id FROM case_assignments WHERE case_id=? AND unassigned_at IS NULL LIMIT 1");
    $st->execute([(int)$p['case_id']]);
    $gid = (int)($st->fetchColumn() ?: 0);
    if ($gid > 0) {
      NotificationModel::add($gid, "Promesa #{$id} actualizada", "Estado: {$action}", $bp.'/gestor/promise_view.php?id='.$id, 'success');
    }

    redirect_to('admin/promise_view.php?id=' . $id);
  }
}

$page_title = 'Ver promesa';
$active = 'promises';

require __DIR__ . '/../app/views/promises/view.php';
