<?php
// app/core/bootstrap.php
declare(strict_types=1);

$cfg = require __DIR__ . '/../config/config.php';

if (session_status() !== PHP_SESSION_ACTIVE) {
  $params = session_get_cookie_params();

  session_name((string)($cfg['session_name'] ?? 'comcobranzas_sess'));

  session_set_cookie_params([
    'lifetime' => 0,
    'path'     => $params['path'] ?? '/',
    'domain'   => $params['domain'] ?? '',
    'secure'   => true,   // HTTPS
    'httponly' => true,
    'samesite' => 'Lax',
  ]);

  session_start();
}

require_once __DIR__ . '/../helpers/helpers.php';
require_once __DIR__ . '/db.php';
require_once __DIR__ . '/csrf.php';
require_once __DIR__ . '/auth.php';
