<?php
// app/core/csrf.php
declare(strict_types=1);

function csrf_token(): string {
  if (empty($_SESSION['_csrf'])) {
    $_SESSION['_csrf'] = bin2hex(random_bytes(32));
  }
  return (string)$_SESSION['_csrf'];
}

function csrf_field(): string {
  $t = htmlspecialchars(csrf_token(), ENT_QUOTES, 'UTF-8');
  return '<input type="hidden" name="_csrf" value="'.$t.'">';
}

function csrf_verify(): void {
  $sent = (string)($_POST['_csrf'] ?? '');
  $sess = (string)($_SESSION['_csrf'] ?? '');
  if (!$sent || !$sess || !hash_equals($sess, $sent)) {
    http_response_code(419);
    exit('CSRF inválido.');
  }
}
