<?php
// app/models/AssignmentModel.php
declare(strict_types=1);

final class AssignmentModel {

  public static function currentGestorId(int $case_id): ?int {
    $st = db()->prepare("
      SELECT gestor_user_id
      FROM case_assignments
      WHERE case_id=? AND unassigned_at IS NULL
      ORDER BY assigned_at DESC
      LIMIT 1
    ");
    $st->execute([$case_id]);
    $id = $st->fetchColumn();
    return $id !== false ? (int)$id : null;
  }

  public static function history(int $case_id): array {
    $st = db()->prepare("
      SELECT a.*, u.name AS gestor_name
      FROM case_assignments a
      JOIN users u ON u.id=a.gestor_user_id
      WHERE a.case_id=?
      ORDER BY a.assigned_at DESC
    ");
    $st->execute([$case_id]);
    return $st->fetchAll(PDO::FETCH_ASSOC) ?: [];
  }

  public static function assign(int $case_id, int $gestor_id, int $by_user_id): void {
    // cerrar asignación anterior
    db()->prepare("
      UPDATE case_assignments
      SET unassigned_at = NOW()
      WHERE case_id=? AND unassigned_at IS NULL
    ")->execute([$case_id]);

    // crear nueva
    db()->prepare("
      INSERT INTO case_assignments (case_id, gestor_user_id, assigned_by, assigned_at)
      VALUES (?,?,?,NOW())
    ")->execute([$case_id, $gestor_id, $by_user_id]);
  }
}
