<?php
// app/models/ExpedientModel.php
declare(strict_types=1);

class ExpedientModel {

  public static function listByCase(int $case_id): array {
    $st = db()->prepare("
      SELECT e.*,
             u.name AS created_by_name
      FROM case_expedients e
      LEFT JOIN users u ON u.id = e.created_by
      WHERE e.case_id = ?
      ORDER BY e.id DESC
    ");
    $st->execute([$case_id]);
    return $st->fetchAll() ?: [];
  }

  public static function listByDebtorUser(int $debtor_user_id): array {
    // Deudor solo tiene 1 caso; listamos expedientes del caso
    $st = db()->prepare("
      SELECT e.*,
             u.name AS created_by_name,
             c.debtor_user_id
      FROM case_expedients e
      JOIN cases c ON c.id = e.case_id
      LEFT JOIN users u ON u.id = e.created_by
      WHERE c.debtor_user_id = ?
      ORDER BY e.id DESC
    ");
    $st->execute([$debtor_user_id]);
    return $st->fetchAll() ?: [];
  }

  public static function find(int $id): ?array {
    $st = db()->prepare("
      SELECT e.*, c.debtor_user_id
      FROM case_expedients e
      JOIN cases c ON c.id = e.case_id
      WHERE e.id = ?
      LIMIT 1
    ");
    $st->execute([$id]);
    $r = $st->fetch();
    return $r ?: null;
  }
}
