<?php
declare(strict_types=1);

class ImportModel {

  public static function create(string $original, string $stored, int $created_by): int {
    $st = db()->prepare("
      INSERT INTO import_jobs (original_name, stored_path, created_by)
      VALUES (?,?,?)
    ");
    $st->execute([$original, $stored, $created_by]);
    return (int)db()->lastInsertId();
  }

  public static function list(int $limit=50): array {
    $st = db()->prepare("SELECT * FROM import_jobs ORDER BY id DESC LIMIT ?");
    $st->bindValue(1, $limit, PDO::PARAM_INT);
    $st->execute();
    return $st->fetchAll() ?: [];
  }

  public static function find(int $id): ?array {
    $st = db()->prepare("SELECT * FROM import_jobs WHERE id=? LIMIT 1");
    $st->execute([$id]);
    $r = $st->fetch();
    return $r ?: null;
  }

  public static function setMapped(int $id, array $mapping, array $options): void {
    $st = db()->prepare("
      UPDATE import_jobs
      SET status='mapped', mapping_json=?, options_json=?
      WHERE id=?
    ");
    $st->execute([json_encode($mapping, JSON_UNESCAPED_UNICODE), json_encode($options, JSON_UNESCAPED_UNICODE), $id]);
  }

  public static function setRunning(int $id): void {
    db()->prepare("UPDATE import_jobs SET status='running' WHERE id=?")->execute([$id]);
  }

  public static function setDone(int $id, int $total, int $inserted, int $errors, string $log): void {
    $st = db()->prepare("
      UPDATE import_jobs
      SET status='done', total_rows=?, inserted_cases=?, errors_count=?, log_text=?
      WHERE id=?
    ");
    $st->execute([$total, $inserted, $errors, $log, $id]);
  }

  public static function setError(int $id, string $log): void {
    db()->prepare("UPDATE import_jobs SET status='error', log_text=? WHERE id=?")->execute([$log, $id]);
  }
}
