<?php
declare(strict_types=1);

class NotificationModel {

  public static function add(int $user_id, string $title, ?string $body, ?string $url, string $level='info'): void {
    $st = db()->prepare("
      INSERT INTO notifications (user_id, title, body, url, level)
      VALUES (?,?,?,?,?)
    ");
    $st->execute([$user_id, $title, $body, $url, $level]);
  }

  public static function unreadCount(int $user_id): int {
    $st = db()->prepare("SELECT COUNT(*) FROM notifications WHERE user_id=? AND is_read=0");
    $st->execute([$user_id]);
    return (int)($st->fetchColumn() ?: 0);
  }

  public static function latest(int $user_id, int $limit=10): array {
    $st = db()->prepare("SELECT * FROM notifications WHERE user_id=? ORDER BY id DESC LIMIT ?");
    $st->bindValue(1, $user_id, PDO::PARAM_INT);
    $st->bindValue(2, $limit, PDO::PARAM_INT);
    $st->execute();
    return $st->fetchAll() ?: [];
  }

  public static function markAllRead(int $user_id): void {
    db()->prepare("UPDATE notifications SET is_read=1 WHERE user_id=?")->execute([$user_id]);
  }
}
