<?php
declare(strict_types=1);

class PaymentModel {

  public static function listByCase(int $case_id): array {
    $st = db()->prepare("
      SELECT p.*, u.name AS created_by_name
      FROM case_payments p
      LEFT JOIN users u ON u.id = p.created_by
      WHERE p.case_id=?
      ORDER BY p.payment_date DESC, p.id DESC
    ");
    $st->execute([$case_id]);
    return $st->fetchAll() ?: [];
  }

  public static function sumPaid(int $case_id): float {
    $st = db()->prepare("SELECT IFNULL(SUM(amount),0) FROM case_payments WHERE case_id=?");
    $st->execute([$case_id]);
    return (float)$st->fetchColumn();
  }

  public static function add(array $d): void {
    $st = db()->prepare("
      INSERT INTO case_payments
      (case_id, amount, payment_date, method, note, attachment_path, created_by, created_role)
      VALUES (?,?,?,?,?,?,?,?)
    ");
    $st->execute([
      $d['case_id'], $d['amount'], $d['payment_date'], $d['method'],
      $d['note'], $d['attachment_path'], $d['created_by'], $d['created_role']
    ]);
  }
}
