<?php
declare(strict_types=1);

class PromiseModel {

  public static function listByCase(int $case_id): array {
    $st = db()->prepare("
      SELECT p.*, u.name AS created_by_name
      FROM case_promises p
      LEFT JOIN users u ON u.id = p.created_by
      WHERE p.case_id=?
      ORDER BY p.id DESC
    ");
    $st->execute([$case_id]);
    return $st->fetchAll() ?: [];
  }

  public static function listMyDebtor(int $debtor_user_id): array {
    $st = db()->prepare("
      SELECT p.*
      FROM case_promises p
      JOIN cases c ON c.id = p.case_id
      WHERE c.debtor_user_id = ?
      ORDER BY p.id DESC
    ");
    $st->execute([$debtor_user_id]);
    return $st->fetchAll() ?: [];
  }

  public static function find(int $id): ?array {
    $st = db()->prepare("
      SELECT p.*, c.debtor_user_id
      FROM case_promises p
      JOIN cases c ON c.id = p.case_id
      WHERE p.id=?
      LIMIT 1
    ");
    $st->execute([$id]);
    $r = $st->fetch();
    return $r ?: null;
  }

  public static function create(array $d): int {
    $st = db()->prepare("
      INSERT INTO case_promises
      (case_id, promised_amount, promised_date, status, note, created_by, created_role)
      VALUES (?,?,?,?,?,?,?)
    ");
    $st->execute([
      $d['case_id'], $d['promised_amount'], $d['promised_date'],
      'active', $d['note'], $d['created_by'], $d['created_role']
    ]);
    return (int)db()->lastInsertId();
  }

  public static function resolve(int $id, string $status, int $by, ?string $note): void {
    $st = db()->prepare("
      UPDATE case_promises
      SET status=?, resolved_at=NOW(), resolved_by=?, resolve_note=?
      WHERE id=?
    ");
    $st->execute([$status, $by, $note, $id]);
  }

  public static function markBrokenOverdue(int $days_grace = 0): int {
    // marca como broken si está vencida y sigue active
    $sql = "
      UPDATE case_promises
      SET status='broken', resolved_at=NOW(), resolve_note='Marcada automática: vencida'
      WHERE status='active'
        AND promised_date < DATE_SUB(CURDATE(), INTERVAL ? DAY)
    ";
    $st = db()->prepare($sql);
    $st->execute([$days_grace]);
    return (int)$st->rowCount();
  }
}
