<?php
declare(strict_types=1);
require __DIR__ . '/../layouts/top.php';
$bp = base_path();
?>
<div class="row">
  <div class="col-md-6">
    <div class="card">
      <div class="card-header d-flex align-items-center justify-content-between">
        <h3 class="card-title">Información del caso</h3>
        <div class="btn-group">
          <a class="btn btn-sm btn-primary" href="<?= h($bp) ?>/admin/case_chat.php?id=<?= (int)$case['id'] ?>">
            <i class="fas fa-comments mr-1"></i> Chat
          </a>
          <a class="btn btn-sm btn-outline-secondary" href="<?= h($bp) ?>/admin/expedients.php?case_id=<?= (int)$case['id'] ?>">
            <i class="fas fa-file-pdf mr-1"></i> Expedientes
          </a>
        </div>
      </div>
      <div class="card-body">
        <p><b>Deudor:</b> <?= h($case['debtor_name']) ?></p>
        <p><b>Cédula:</b> <?= h($case['cedula']) ?></p>
        <p><b>Cliente:</b> <?= h($case['client_name']) ?></p>
        <p><b>Estado:</b> <?= h($case['status']) ?></p>
        <p><b>Dirección:</b> <?= h((string)$case['address']) ?></p>
      </div>
    </div>
  </div>

  <div class="col-md-6">
    <div class="card">
      <div class="card-header"><h3 class="card-title">Estado del sistema</h3></div>
      <div class="card-body">
        <ul class="text-muted mb-0">
          <li>Chat por caso + adjuntos ✅</li>
          <li>Expedientes PDF multi-hoja ✅</li>
          <li>Parche 06: pagos + intereses + métricas</li>
          <li>Parche 07: importador CSV/Excel</li>
        </ul>
      </div>
    </div>
  </div>
</div>
<?php require __DIR__ . '/../layouts/bottom.php'; ?>
