<?php
declare(strict_types=1);

require_once __DIR__ . '/../../models/CaseModel.php';
require __DIR__ . '/../layouts/top.php';

$cases = CaseModel::all();
?>
<div class="card">
  <div class="card-header">
    <h3 class="card-title">Casos globales</h3>
  </div>
  <div class="card-body table-responsive p-0">
    <table class="table table-hover text-sm">
      <thead>
        <tr>
          <th>ID</th>
          <th>Deudor</th>
          <th>Cliente</th>
          <th>Gestor</th>
          <th>Estado</th>
          <th>Creado</th>
          <th></th>
        </tr>
      </thead>
      <tbody>
        <?php foreach ($cases as $c): ?>
        <tr>
          <td><?= (int)$c['id'] ?></td>
          <td><?= h($c['debtor_name']) ?></td>
          <td><?= h($c['client_name']) ?></td>
          <td><?= h($c['gestor_name'] ?? '—') ?></td>
          <td>
            <span class="badge badge-info"><?= h($c['status']) ?></span>
          </td>
          <td><?= h(date('d/m/Y', strtotime($c['created_at']))) ?></td>
          <td>
            <a href="case_view.php?id=<?= (int)$c['id'] ?>" class="btn btn-xs btn-primary">
              Ver
            </a>
          </td>
        </tr>
        <?php endforeach; ?>
        <?php if (!$cases): ?>
        <tr><td colspan="7" class="text-center text-muted">Sin casos</td></tr>
        <?php endif; ?>
      </tbody>
    </table>
  </div>
</div>
<?php require __DIR__ . '/../layouts/bottom.php'; ?>
