<?php
declare(strict_types=1);

/**
 * Requiere variables:
 * - $user, $page_title, $active
 * - $case (array)
 * - $messages (array)
 * - $att_map (map message_id => attachments[])
 */

require __DIR__ . '/../layouts/top.php';

$bp = base_path();
$myRole = (string)$user['role'];
$myId = (int)$user['id'];

function role_badge(string $r): string {
  if ($r === 'admin') return 'badge-danger';
  if ($r === 'gestor') return 'badge-primary';
  return 'badge-success';
}
?>
<div class="row">
  <div class="col-12 col-lg-4">
    <div class="card">
      <div class="card-header"><h3 class="card-title">Caso</h3></div>
      <div class="card-body text-sm">
        <div><b>#<?= (int)$case['id'] ?></b></div>
        <div><b>Deudor:</b> <?= h($case['debtor_name']) ?></div>
        <div><b>Cédula:</b> <?= h($case['cedula']) ?></div>
        <div><b>Cliente:</b> <?= h($case['client_name']) ?></div>
        <div><b>Estado:</b> <?= h($case['status']) ?></div>
      </div>
    </div>

    <?php if ($myRole !== 'deudor'): ?>
      <div class="callout callout-info text-sm">
        Adjunta fotos o PDF. (Parche 05 agregará recorte + escáner + PDF multi-hoja)
      </div>
    <?php endif; ?>
  </div>

  <div class="col-12 col-lg-8">
    <div class="card chat-card">
      <div class="card-header">
        <h3 class="card-title"><i class="fas fa-comments mr-2"></i><?= h($page_title) ?></h3>
      </div>

      <div class="card-body chat-body" id="chatBody">
        <?php if (!$messages): ?>
          <div class="text-muted text-center py-4">Sin mensajes todavía</div>
        <?php endif; ?>

        <?php foreach ($messages as $m): ?>
          <?php
            $senderRole = (string)$m['sender_role'];
            $senderId   = (int)$m['sender_user_id'];
            $mine = ($senderRole === $myRole && $senderId === $myId);
            $bubbleClass = $mine ? 'chat-bubble mine' : 'chat-bubble';
            $senderName = (string)($m['sender_name'] ?? $senderRole);
          ?>
          <div class="<?= h($bubbleClass) ?>">
            <div class="chat-meta">
              <span class="badge <?= h(role_badge($senderRole)) ?>"><?= h(strtoupper($senderRole)) ?></span>
              <span class="ml-1"><?= h($senderName) ?></span>
              <span class="chat-time ml-2"><?= h(date('d/m H:i', strtotime((string)$m['created_at']))) ?></span>
            </div>

            <?php if (trim((string)$m['message_text']) !== ''): ?>
              <div class="chat-text"><?= nl2br(h((string)$m['message_text'])) ?></div>
            <?php endif; ?>

            <?php $atts = $att_map[(int)$m['id']] ?? []; ?>
            <?php if ($atts): ?>
              <div class="chat-atts">
                <?php foreach ($atts as $a): ?>
                  <?php
                    $attId = (int)$a['id'];
                    $mime  = (string)$a['mime_type'];
                    $name  = (string)$a['file_name'];
                    $isImg = (strpos($mime, 'image/') === 0);
                  ?>
                  <div class="chat-att">
                    <?php if ($isImg): ?>
                      <a href="<?= h($bp) ?>/chat_file.php?att=<?= $attId ?>" target="_blank">
                        <img class="chat-thumb" src="<?= h($bp) ?>/chat_file.php?att=<?= $attId ?>" alt="<?= h($name) ?>">
                      </a>
                    <?php else: ?>
                      <a class="btn btn-xs btn-outline-secondary" href="<?= h($bp) ?>/chat_file.php?att=<?= $attId ?>" target="_blank">
                        <i class="fas fa-file-pdf mr-1"></i><?= h($name) ?>
                      </a>
                    <?php endif; ?>
                  </div>
                <?php endforeach; ?>
              </div>
            <?php endif; ?>
          </div>
        <?php endforeach; ?>
      </div>

      <div class="card-footer">
        <form method="post" enctype="multipart/form-data">
          <?= csrf_field() ?>
          <div class="input-group">
            <textarea name="message" class="form-control" rows="1" placeholder="Escribe un mensaje..." style="resize:none"></textarea>
            <div class="input-group-append">
              <label class="btn btn-outline-secondary mb-0">
                <i class="fas fa-paperclip"></i>
                <input type="file" name="files[]" multiple accept="image/*,application/pdf" style="display:none">
              </label>
              <button class="btn btn-primary" type="submit">
                <i class="fas fa-paper-plane"></i>
              </button>
            </div>
          </div>
          <small class="text-muted d-block mt-2">
            Desde celular puedes usar cámara al adjuntar imagen.
          </small>
        </form>
      </div>
    </div>
  </div>
</div>

<?php require __DIR__ . '/../layouts/bottom.php'; ?>
