<?php
declare(strict_types=1);
require __DIR__ . '/../layouts/top.php';

$bp = base_path();
?>
<div class="row">
  <div class="col-12 col-md-3">
    <div class="small-box bg-info">
      <div class="inner">
        <h3 id="k_total_cases">0</h3>
        <p>Casos totales</p>
      </div>
      <div class="icon"><i class="fas fa-folder-open"></i></div>
      <a href="<?= h($bp) ?>/admin/cases.php" class="small-box-footer">Ver casos <i class="fas fa-arrow-circle-right"></i></a>
    </div>
  </div>

  <div class="col-12 col-md-3">
    <div class="small-box bg-warning">
      <div class="inner">
        <h3 id="k_pending">0</h3>
        <p>Pendiente (base)</p>
      </div>
      <div class="icon"><i class="fas fa-exclamation-triangle"></i></div>
      <a href="<?= h($bp) ?>/admin/cases.php?status=mora" class="small-box-footer">Ver mora <i class="fas fa-arrow-circle-right"></i></a>
    </div>
  </div>

  <div class="col-12 col-md-3">
    <div class="small-box bg-success">
      <div class="inner">
        <h3 id="k_total_paid">0</h3>
        <p>Cobrado total</p>
      </div>
      <div class="icon"><i class="fas fa-coins"></i></div>
      <a href="<?= h($bp) ?>/admin/payments_global.php" class="small-box-footer">Pagos <i class="fas fa-arrow-circle-right"></i></a>
    </div>
  </div>

  <div class="col-12 col-md-3">
    <div class="small-box bg-secondary">
      <div class="inner">
        <h3 id="k_paid_30">0</h3>
        <p>Cobrado 30 días</p>
      </div>
      <div class="icon"><i class="fas fa-chart-line"></i></div>
      <a href="#" class="small-box-footer">Actualizado hoy</a>
    </div>
  </div>
</div>

<div class="row">
  <div class="col-lg-7">
    <div class="card">
      <div class="card-header">
        <h3 class="card-title"><i class="fas fa-chart-line mr-1"></i> Cobrado últimos 14 días</h3>
      </div>
      <div class="card-body">
        <canvas id="chPaid14" height="120"></canvas>
      </div>
    </div>
  </div>

  <div class="col-lg-5">
    <div class="card">
      <div class="card-header">
        <h3 class="card-title"><i class="fas fa-chart-pie mr-1"></i> Casos por estado</h3>
      </div>
      <div class="card-body">
        <canvas id="chStates" height="120"></canvas>
      </div>
    </div>
  </div>
</div>

<div class="row">
  <div class="col-lg-6">
    <div class="card">
      <div class="card-header">
        <h3 class="card-title"><i class="fas fa-building mr-1"></i> Top clientes por pendiente (base)</h3>
      </div>
      <div class="card-body">
        <canvas id="chTopClients" height="130"></canvas>
        <small class="text-muted">Pendiente base = capital - pagos (sin interés).</small>
      </div>
    </div>
  </div>

  <div class="col-lg-6">
    <div class="card">
      <div class="card-header">
        <h3 class="card-title"><i class="fas fa-user-tie mr-1"></i> Top gestores por cobrado (30 días)</h3>
      </div>
      <div class="card-body">
        <canvas id="chTopGestors" height="130"></canvas>
      </div>
    </div>
  </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/chart.js@4.4.1/dist/chart.umd.min.js"></script>
<script>
(async function(){
  const res = await fetch('<?= h($bp) ?>/admin/dashboard_api.php', {headers:{'Accept':'application/json'}});
  const data = await res.json();

  const fmt = (n)=> new Intl.NumberFormat('es-CR',{minimumFractionDigits:2, maximumFractionDigits:2}).format(Number(n||0));
  const fmt0 = (n)=> new Intl.NumberFormat('es-CR',{maximumFractionDigits:0}).format(Number(n||0));

  document.getElementById('k_total_cases').textContent = fmt0(data.kpis.total_cases);
  document.getElementById('k_pending').textContent     = fmt(data.kpis.pending_base);
  document.getElementById('k_total_paid').textContent  = fmt(data.kpis.total_paid);
  document.getElementById('k_paid_30').textContent     = fmt(data.kpis.paid_30);

  // Line Paid14
  new Chart(document.getElementById('chPaid14'), {
    type: 'line',
    data: { labels: data.charts.paid14.labels, datasets: [{ label:'Cobrado', data: data.charts.paid14.values, tension:0.3 }]},
    options: { responsive:true, plugins:{legend:{display:false}} }
  });

  // Donut States
  new Chart(document.getElementById('chStates'), {
    type: 'doughnut',
    data: { labels: data.charts.states.labels, datasets: [{ data: data.charts.states.values }]},
    options: { responsive:true }
  });

  // Bar Top Clients
  new Chart(document.getElementById('chTopClients'), {
    type: 'bar',
    data: { labels: data.charts.top_clients_pending.labels, datasets: [{ label:'Pendiente', data: data.charts.top_clients_pending.values }]},
    options: { responsive:true, plugins:{legend:{display:false}} }
  });

  // Bar Top Gestors
  new Chart(document.getElementById('chTopGestors'), {
    type: 'bar',
    data: { labels: data.charts.top_gestors_paid30.labels, datasets: [{ label:'Cobrado 30d', data: data.charts.top_gestors_paid30.values }]},
    options: { responsive:true, plugins:{legend:{display:false}} }
  });

})();
</script>

<?php require __DIR__ . '/../layouts/bottom.php'; ?>
