<?php
declare(strict_types=1);
require __DIR__ . '/../layouts/top.php';

$bp = base_path();
?>
<div class="row">
  <div class="col-12 col-md-3">
    <div class="small-box bg-info">
      <div class="inner">
        <h3 id="g_cases">0</h3>
        <p>Mis casos</p>
      </div>
      <div class="icon"><i class="fas fa-briefcase"></i></div>
      <a href="<?= h($bp) ?>/gestor/cases.php" class="small-box-footer">Ver mis casos <i class="fas fa-arrow-circle-right"></i></a>
    </div>
  </div>

  <div class="col-12 col-md-3">
    <div class="small-box bg-warning">
      <div class="inner">
        <h3 id="g_pending">0</h3>
        <p>Pendiente (base)</p>
      </div>
      <div class="icon"><i class="fas fa-exclamation-circle"></i></div>
      <a href="<?= h($bp) ?>/gestor/cases.php?status=mora" class="small-box-footer">Ver mora <i class="fas fa-arrow-circle-right"></i></a>
    </div>
  </div>

  <div class="col-12 col-md-3">
    <div class="small-box bg-success">
      <div class="inner">
        <h3 id="g_paid">0</h3>
        <p>Cobrado total</p>
      </div>
      <div class="icon"><i class="fas fa-coins"></i></div>
      <a href="<?= h($bp) ?>/gestor/payments_global.php" class="small-box-footer">Pagos <i class="fas fa-arrow-circle-right"></i></a>
    </div>
  </div>

  <div class="col-12 col-md-3">
    <div class="small-box bg-secondary">
      <div class="inner">
        <h3 id="g_paid30">0</h3>
        <p>Cobrado 30 días</p>
      </div>
      <div class="icon"><i class="fas fa-chart-line"></i></div>
      <a href="#" class="small-box-footer">Actualizado hoy</a>
    </div>
  </div>
</div>

<div class="row">
  <div class="col-lg-7">
    <div class="card">
      <div class="card-header">
        <h3 class="card-title"><i class="fas fa-chart-line mr-1"></i> Mis cobros últimos 14 días</h3>
      </div>
      <div class="card-body">
        <canvas id="chPaid14" height="120"></canvas>
      </div>
    </div>
  </div>

  <div class="col-lg-5">
    <div class="card">
      <div class="card-header">
        <h3 class="card-title"><i class="fas fa-chart-pie mr-1"></i> Mis casos por estado</h3>
      </div>
      <div class="card-body">
        <canvas id="chStates" height="120"></canvas>
      </div>
    </div>
  </div>
</div>

<div class="card">
  <div class="card-header">
    <h3 class="card-title"><i class="fas fa-list mr-1"></i> Top pendientes</h3>
  </div>
  <div class="card-body table-responsive p-0">
    <table class="table table-hover text-sm mb-0">
      <thead>
        <tr>
          <th>Caso</th>
          <th>Deudor</th>
          <th>Cédula</th>
          <th>Pendiente (base)</th>
          <th></th>
        </tr>
      </thead>
      <tbody id="topCasesBody">
        <tr><td colspan="5" class="text-center text-muted p-3">Cargando…</td></tr>
      </tbody>
    </table>
  </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/chart.js@4.4.1/dist/chart.umd.min.js"></script>
<script>
(async function(){
  const res = await fetch('<?= h($bp) ?>/gestor/dashboard_api.php', {headers:{'Accept':'application/json'}});
  const data = await res.json();

  const fmt = (n)=> new Intl.NumberFormat('es-CR',{minimumFractionDigits:2, maximumFractionDigits:2}).format(Number(n||0));
  const fmt0 = (n)=> new Intl.NumberFormat('es-CR',{maximumFractionDigits:0}).format(Number(n||0));

  document.getElementById('g_cases').textContent = fmt0(data.kpis.assigned_cases);
  document.getElementById('g_pending').textContent = fmt(data.kpis.pending_base);
  document.getElementById('g_paid').textContent = fmt(data.kpis.paid);
  document.getElementById('g_paid30').textContent = fmt(data.kpis.paid_30);

  new Chart(document.getElementById('chPaid14'), {
    type: 'line',
    data: { labels: data.charts.paid14.labels, datasets: [{ label:'Cobrado', data: data.charts.paid14.values, tension:0.3 }]},
    options: { responsive:true, plugins:{legend:{display:false}} }
  });

  new Chart(document.getElementById('chStates'), {
    type: 'doughnut',
    data: { labels: data.charts.states.labels, datasets: [{ data: data.charts.states.values }]},
    options: { responsive:true }
  });

  const body = document.getElementById('topCasesBody');
  const rows = data.top_cases || [];
  if (!rows.length) {
    body.innerHTML = '<tr><td colspan="5" class="text-center text-muted p-3">Sin datos.</td></tr>';
    return;
  }
  body.innerHTML = rows.map(r => `
    <tr>
      <td>#${r.id}</td>
      <td>${escapeHtml(r.debtor_name||'')}</td>
      <td>${escapeHtml(r.cedula||'')}</td>
      <td>${fmt(r.pending)}</td>
      <td><a class="btn btn-xs btn-outline-secondary" href="<?= h($bp) ?>/gestor/case_view.php?id=${r.id}">Ver</a></td>
    </tr>
  `).join('');

  function escapeHtml(s){
    return String(s).replace(/[&<>"']/g, m => ({'&':'&amp;','<':'&lt;','>':'&gt;','"':'&quot;',"'":'&#039;'}[m]));
  }
})();
</script>

<?php require __DIR__ . '/../layouts/bottom.php'; ?>
