<?php
declare(strict_types=1);

require_once __DIR__ . '/../../models/CaseModel.php';
require __DIR__ . '/../layouts/top.php';

$case = CaseModel::byDebtorUser((int)$user['id']);
?>
<div class="card">
  <div class="card-header">
    <h3 class="card-title">Mi deuda</h3>
  </div>
  <div class="card-body">
    <?php if ($case): ?>
      <p><b>Cliente:</b> <?= h($case['client_name']) ?></p>
      <p><b>Estado:</b> <?= h($case['status']) ?></p>
      <p><b>Dirección:</b> <?= h($case['address']) ?></p>
      <p class="text-muted">
        Próximamente: pagos, chat con gestor y expedientes.
      </p>
    <?php else: ?>
      <p class="text-muted">No hay deuda asignada.</p>
    <?php endif; ?>
  </div>
</div>
<?php require __DIR__ . '/../layouts/bottom.php'; ?>
