<?php
declare(strict_types=1);
require __DIR__ . '/../layouts/top.php';

$bp = base_path();
?>
<div class="card">
  <div class="card-header">
    <h3 class="card-title">Mis expedientes</h3>
  </div>
  <div class="card-body table-responsive p-0">
    <table class="table table-hover text-sm mb-0">
      <thead>
        <tr>
          <th>ID</th>
          <th>Título</th>
          <th>Fecha</th>
          <th></th>
        </tr>
      </thead>
      <tbody>
        <?php foreach (($expedients ?? []) as $e): ?>
          <tr>
            <td><?= (int)$e['id'] ?></td>
            <td><?= h($e['title']) ?></td>
            <td><?= h(date('d/m/Y H:i', strtotime((string)$e['created_at']))) ?></td>
            <td>
              <a class="btn btn-xs btn-outline-secondary" target="_blank"
                 href="<?= h($bp) ?>/expedient_file.php?id=<?= (int)$e['id'] ?>">
                <i class="fas fa-file-pdf mr-1"></i> Ver PDF
              </a>
            </td>
          </tr>
        <?php endforeach; ?>

        <?php if (empty($expedients)): ?>
          <tr><td colspan="4" class="text-center text-muted p-3">No tienes expedientes aún.</td></tr>
        <?php endif; ?>
      </tbody>
    </table>
  </div>
</div>
<?php require __DIR__ . '/../layouts/bottom.php'; ?>
