<?php
declare(strict_types=1);
require __DIR__ . '/../layouts/top.php';

$bp = base_path();
$isAdmin = ($user['role'] === 'admin');
$uploadUrl = $isAdmin
  ? ($bp . '/admin/expedients_upload.php?case_id=' . (int)$case['id'])
  : ($bp . '/gestor/expedients_upload.php?case_id=' . (int)$case['id']);
?>
<div class="card">
  <div class="card-header d-flex align-items-center justify-content-between">
    <h3 class="card-title">Expedientes del caso #<?= (int)$case['id'] ?></h3>
    <a class="btn btn-sm btn-primary" href="<?= h($uploadUrl) ?>">
      <i class="fas fa-camera mr-1"></i> Nuevo expediente
    </a>
  </div>

  <div class="card-body table-responsive p-0">
    <table class="table table-hover text-sm mb-0">
      <thead>
        <tr>
          <th>ID</th>
          <th>Título</th>
          <th>Creado por</th>
          <th>Fecha</th>
          <th></th>
        </tr>
      </thead>
      <tbody>
      <?php foreach (($expedients ?? []) as $e): ?>
        <tr>
          <td><?= (int)$e['id'] ?></td>
          <td><?= h($e['title']) ?></td>
          <td>
            <?= h((string)($e['created_by_name'] ?? '—')) ?>
            <span class="badge badge-light ml-1"><?= h(strtoupper((string)$e['created_role'])) ?></span>
          </td>
          <td><?= h(date('d/m/Y H:i', strtotime((string)$e['created_at']))) ?></td>
          <td>
            <a class="btn btn-xs btn-outline-secondary" target="_blank"
               href="<?= h($bp) ?>/expedient_file.php?id=<?= (int)$e['id'] ?>">
              <i class="fas fa-file-pdf mr-1"></i> Ver PDF
            </a>
          </td>
        </tr>
      <?php endforeach; ?>

      <?php if (empty($expedients)): ?>
        <tr><td colspan="5" class="text-center text-muted p-3">No hay expedientes aún.</td></tr>
      <?php endif; ?>
      </tbody>
    </table>
  </div>
</div>
<?php require __DIR__ . '/../layouts/bottom.php'; ?>
