<?php
declare(strict_types=1);
require __DIR__ . '/../layouts/top.php';

$bp = base_path();
// Endpoint según rol
$upload_action = ($user['role'] === 'admin')
  ? ($bp . '/admin/expedient_upload.php')
  : ($bp . '/gestor/expedient_upload.php');
?>
<div class="card">
  <div class="card-header">
    <h3 class="card-title">Nuevo expediente</h3>
  </div>

  <div class="card-body">
    <form id="expForm" method="post" action="<?= h($upload_action) ?>" enctype="multipart/form-data">
      <?= csrf_field() ?>
      <input type="hidden" name="case_id" value="<?= (int)$case['id'] ?>">

      <div class="form-group">
        <label>Título del expediente</label>
        <input type="text" name="title" class="form-control" required>
      </div>

      <div class="form-group">
        <label>Fotos / documentos</label>
        <input type="file"
               id="imagesInput"
               accept="image/*"
               capture="environment"
               multiple
               class="form-control">
        <small class="text-muted">
          Puedes usar la cámara del celular. Cada imagen se recorta y procesa.
        </small>
      </div>

      <div id="previewArea" class="d-flex flex-wrap"></div>

      <button type="button" id="generatePdf" class="btn btn-primary mt-3">
        <i class="fas fa-file-pdf mr-1"></i> Generar PDF y Guardar
      </button>
    </form>
  </div>
</div>
<?php require __DIR__ . '/../layouts/bottom.php'; ?>

<link rel="stylesheet" href="https://unpkg.com/cropperjs/dist/cropper.css">
<script src="https://unpkg.com/cropperjs/dist/cropper.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jspdf/2.5.1/jspdf.umd.min.js"></script>
<script src="<?= h($bp) ?>/assets/expedients.js"></script>
