<?php
declare(strict_types=1);
require __DIR__ . '/../layouts/top.php';
$bp = base_path();
?>
<div class="card">
  <div class="card-header d-flex align-items-center justify-content-between">
    <h3 class="card-title">Detalle del caso</h3>
    <div class="btn-group">
      <a class="btn btn-sm btn-primary" href="<?= h($bp) ?>/gestor/case_chat.php?id=<?= (int)$case['id'] ?>">
        <i class="fas fa-comments mr-1"></i> Chat
      </a>
      <a class="btn btn-sm btn-outline-secondary" href="<?= h($bp) ?>/gestor/expedients.php?case_id=<?= (int)$case['id'] ?>">
        <i class="fas fa-file-pdf mr-1"></i> Expedientes
      </a>
    </div>
  </div>
  <div class="card-body">
    <p><b>Deudor:</b> <?= h($case['debtor_name']) ?></p>
    <p><b>Cédula:</b> <?= h($case['cedula']) ?></p>
    <p><b>Cliente:</b> <?= h($case['client_name']) ?></p>
    <p><b>Estado:</b> <?= h($case['status']) ?></p>
    <p><b>Tel:</b> <?= h((string)($case['phone'] ?? '—')) ?></p>
    <p><b>Dirección:</b> <?= h((string)($case['address'] ?? '—')) ?></p>
  </div>
</div>
<?php require __DIR__ . '/../layouts/bottom.php'; ?>
