<?php
declare(strict_types=1);

require_once __DIR__ . '/../../models/CaseModel.php';
require __DIR__ . '/../layouts/top.php';

$cases = CaseModel::byGestor((int)$user['id']);
?>
<div class="card">
  <div class="card-header">
    <h3 class="card-title">Mis casos</h3>
  </div>
  <div class="card-body table-responsive p-0">
    <table class="table table-hover text-sm">
      <thead>
        <tr>
          <th>ID</th>
          <th>Deudor</th>
          <th>Cliente</th>
          <th>Estado</th>
          <th></th>
        </tr>
      </thead>
      <tbody>
        <?php foreach ($cases as $c): ?>
        <tr>
          <td><?= (int)$c['id'] ?></td>
          <td><?= h($c['debtor_name']) ?></td>
          <td><?= h($c['client_name']) ?></td>
          <td><span class="badge badge-info"><?= h($c['status']) ?></span></td>
          <td>
            <a href="case_view.php?id=<?= (int)$c['id'] ?>" class="btn btn-xs btn-primary">
              Abrir
            </a>
          </td>
        </tr>
        <?php endforeach; ?>
        <?php if (!$cases): ?>
        <tr><td colspan="5" class="text-center text-muted">Sin casos asignados</td></tr>
        <?php endif; ?>
      </tbody>
    </table>
  </div>
</div>
<?php require __DIR__ . '/../layouts/bottom.php'; ?>
