<?php
declare(strict_types=1);
require __DIR__ . '/../layouts/top.php';
$bp = base_path();
?>
<div class="card">
  <div class="card-header d-flex justify-content-between">
    <h3 class="card-title">Importaciones (CSV)</h3>
    <a class="btn btn-sm btn-primary" href="<?= h($bp) ?>/admin/import_new.php">
      <i class="fas fa-upload mr-1"></i> Nueva importación
    </a>
  </div>

  <div class="card-body table-responsive p-0">
    <table class="table table-hover text-sm mb-0">
      <thead>
        <tr>
          <th>ID</th>
          <th>Archivo</th>
          <th>Status</th>
          <th>Total</th>
          <th>Insertados</th>
          <th>Errores</th>
          <th>Fecha</th>
        </tr>
      </thead>
      <tbody>
        <?php foreach ($jobs as $j): ?>
          <tr>
            <td><?= (int)$j['id'] ?></td>
            <td><?= h($j['original_name']) ?></td>
            <td><span class="badge badge-info"><?= h($j['status']) ?></span></td>
            <td><?= (int)$j['total_rows'] ?></td>
            <td><?= (int)$j['inserted_cases'] ?></td>
            <td><?= (int)$j['errors_count'] ?></td>
            <td><?= h((string)$j['created_at']) ?></td>
          </tr>
        <?php endforeach; ?>
        <?php if (!$jobs): ?>
          <tr><td colspan="7" class="text-center text-muted p-3">Sin importaciones</td></tr>
        <?php endif; ?>
      </tbody>
    </table>
  </div>
</div>
<?php require __DIR__ . '/../layouts/bottom.php'; ?>
