<?php
declare(strict_types=1);
require __DIR__ . '/../layouts/top.php';
$bp = base_path();
?>
<div class="card">
  <div class="card-header">
    <h3 class="card-title">Mapeo de columnas (Import #<?= (int)$job['id'] ?>)</h3>
  </div>
  <div class="card-body">
    <form method="post" action="<?= h($bp) ?>/admin/import_run.php">
      <?= csrf_field() ?>
      <input type="hidden" name="id" value="<?= (int)$job['id'] ?>">

      <div class="row">
        <div class="col-md-6">
          <h5 class="mb-3">1) Mapeo</h5>

          <?php
          function opt($header, $selected='') {
            $html = '<option value="">—</option>';
            foreach ($header as $h) {
              $sel = ($h === $selected) ? 'selected' : '';
              $html .= '<option '.$sel.' value="'.htmlspecialchars((string)$h, ENT_QUOTES, 'UTF-8').'">'.htmlspecialchars((string)$h).'</option>';
            }
            return $html;
          }
          ?>

          <div class="form-group">
            <label>Cliente (nombre) (opcional si eliges cliente fijo)</label>
            <select class="form-control" name="map_client_name"><?= opt($header) ?></select>
          </div>

          <div class="form-group">
            <label>Cédula (REQUERIDO)</label>
            <select class="form-control" name="map_cedula" required><?= opt($header) ?></select>
          </div>

          <div class="form-group">
            <label>Nombre Deudor</label>
            <select class="form-control" name="map_debtor_name"><?= opt($header) ?></select>
          </div>

          <div class="form-group">
            <label>Teléfono</label>
            <select class="form-control" name="map_phone"><?= opt($header) ?></select>
          </div>

          <div class="form-group">
            <label>Dirección</label>
            <select class="form-control" name="map_address"><?= opt($header) ?></select>
          </div>

          <div class="form-group">
            <label>Monto (REQUERIDO)</label>
            <select class="form-control" name="map_amount" required><?= opt($header) ?></select>
          </div>

          <div class="form-group">
            <label>Fecha inicio deuda (opcional) (YYYY-MM-DD)</label>
            <select class="form-control" name="map_debt_start_date"><?= opt($header) ?></select>
          </div>

          <div class="form-group">
            <label>Estado (opcional)</label>
            <select class="form-control" name="map_status"><?= opt($header) ?></select>
            <small class="text-muted">Si no viene, se usa "mora".</small>
          </div>
        </div>

        <div class="col-md-6">
          <h5 class="mb-3">2) Opciones</h5>

          <div class="form-group">
            <label>Cliente fijo (si lo eliges, ignora "Cliente (nombre)")</label>
            <select class="form-control" name="fixed_client_id">
              <option value="0">— No (usar columna cliente o crear)</option>
              <?php foreach ($clients as $c): ?>
                <option value="<?= (int)$c['id'] ?>"><?= h($c['name']) ?></option>
              <?php endforeach; ?>
            </select>
          </div>

          <div class="form-group">
            <label>Asignación de casos</label>
            <select class="form-control" name="assign_mode" id="assignMode">
              <option value="none">No asignar</option>
              <option value="fixed">Asignar a un gestor</option>
              <option value="round_robin">Round-robin (repartir)</option>
            </select>
          </div>

          <div class="form-group" id="fixedGestorBox" style="display:none">
            <label>Gestor fijo</label>
            <select class="form-control" name="fixed_gestor_id">
              <option value="0">—</option>
              <?php foreach ($gestors as $g): ?>
                <option value="<?= (int)$g['id'] ?>"><?= h($g['name']) ?> (<?= h($g['email'] ?? '') ?>)</option>
              <?php endforeach; ?>
            </select>
          </div>

          <div class="form-group" id="rrBox" style="display:none">
            <label>Gestores para round-robin</label>
            <?php foreach ($gestors as $g): ?>
              <div class="custom-control custom-checkbox">
                <input class="custom-control-input" type="checkbox" id="g<?= (int)$g['id'] ?>" name="rr_gestors[]" value="<?= (int)$g['id'] ?>">
                <label class="custom-control-label" for="g<?= (int)$g['id'] ?>">
                  <?= h($g['name']) ?> (<?= h($g['email'] ?? '') ?>)
                </label>
              </div>
            <?php endforeach; ?>
          </div>

          <hr>

          <div class="custom-control custom-switch">
            <input type="checkbox" class="custom-control-input" id="createDebtor" name="create_debtor_user" value="1">
            <label class="custom-control-label" for="createDebtor">
              Crear usuarios deudor automáticamente (password demo ppc123)
            </label>
          </div>

          <div class="alert alert-warning text-sm mt-3">
            Si tu tabla <code>users</code> no tiene columna <code>cedula</code>, esta opción no creará usuarios (seguro).
          </div>

        </div>
      </div>

      <hr>

      <h5 class="mb-2">3) Preview</h5>
      <div class="table-responsive">
        <table class="table table-sm table-bordered text-sm">
          <thead>
            <tr>
              <?php foreach ($header as $h): ?><th><?= h((string)$h) ?></th><?php endforeach; ?>
            </tr>
          </thead>
          <tbody>
            <?php foreach ($rows as $r): ?>
              <tr>
                <?php foreach ($header as $i => $h): ?>
                  <td><?= h((string)($r[$i] ?? '')) ?></td>
                <?php endforeach; ?>
              </tr>
            <?php endforeach; ?>
            <?php if (!$rows): ?>
              <tr><td colspan="<?= count($header) ?>" class="text-center text-muted">Sin filas de preview</td></tr>
            <?php endif; ?>
          </tbody>
        </table>
      </div>

      <button class="btn btn-success">
        <i class="fas fa-play mr-1"></i> Ejecutar importación
      </button>
    </form>
  </div>
</div>

<script>
  const mode = document.getElementById('assignMode');
  const fixedBox = document.getElementById('fixedGestorBox');
  const rrBox = document.getElementById('rrBox');

  function refresh() {
    fixedBox.style.display = (mode.value === 'fixed') ? '' : 'none';
    rrBox.style.display = (mode.value === 'round_robin') ? '' : 'none';
  }
  mode.addEventListener('change', refresh);
  refresh();
</script>

<?php require __DIR__ . '/../layouts/bottom.php'; ?>
