<?php
declare(strict_types=1);
require __DIR__ . '/../layouts/top.php';
$bp = base_path();
?>
<div class="card">
  <div class="card-header">
    <h3 class="card-title">Nueva importación CSV</h3>
  </div>
  <div class="card-body">
    <?php if (!empty($err)): ?>
      <div class="alert alert-danger"><?= h($err) ?></div>
    <?php endif; ?>

    <div class="alert alert-info text-sm">
      Exporta tu Excel a <b>CSV (UTF-8)</b>. Luego lo subes aquí.
    </div>

    <form method="post" enctype="multipart/form-data">
      <?= csrf_field() ?>
      <div class="form-group">
        <label>Archivo CSV</label>
        <input type="file" name="csv" class="form-control" accept=".csv,text/csv" required>
      </div>
      <button class="btn btn-primary">
        <i class="fas fa-arrow-right mr-1"></i> Continuar
      </button>
    </form>
  </div>
</div>
<?php require __DIR__ . '/../layouts/bottom.php'; ?>
