<?php
// app/views/layouts/top.php
declare(strict_types=1);

/**
 * Variables esperadas:
 * - $page_title (string)
 * - $active (string) menú activo (ej: 'dashboard','cases', etc.)
 * - $user (array) usuario logueado
 */

$cfg = require __DIR__ . '/../../config/config.php';
$bp = base_path();
$title = ($page_title ?? 'Panel') . ' - ' . ($cfg['app_name'] ?? 'Com Cobranzas');

// Sidebar según rol
$role = (string)($user['role'] ?? '');
$sidebar_file = __DIR__ . '/sidebar_' . $role . '.php';
if (!is_file($sidebar_file)) {
  $sidebar_file = __DIR__ . '/sidebar_admin.php';
}
?>
<!doctype html>
<html lang="es">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title><?= h($title) ?></title>

  <!-- AdminLTE (CDN) -->
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/@fortawesome/fontawesome-free@5.15.4/css/all.min.css">
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/admin-lte@3.2/dist/css/adminlte.min.css">
  <link rel="stylesheet" href="<?= h($bp) ?>/assets/app.css">
</head>

<body class="hold-transition sidebar-mini layout-fixed layout-navbar-fixed">
<div class="wrapper">

  <!-- Navbar -->
  <nav class="main-header navbar navbar-expand navbar-white navbar-light">
    <!-- Left navbar -->
    <ul class="navbar-nav">
      <li class="nav-item">
        <a class="nav-link" data-widget="pushmenu" href="#" role="button"><i class="fas fa-bars"></i></a>
      </li>
      <li class="nav-item d-none d-sm-inline-block">
        <a href="<?= h($bp) ?>/index.php" class="nav-link">Inicio</a>
      </li>
    </ul>

    <!-- Right navbar -->
    <ul class="navbar-nav ml-auto">
      <li class="nav-item">
        <span class="nav-link text-sm">
          <i class="far fa-user mr-1"></i>
          <?= h((string)($user['name'] ?? '')) ?>
          <span class="badge badge-light ml-2"><?= h(strtoupper($role)) ?></span>
        </span>
      </li>
      <li class="nav-item">
        <a class="nav-link" href="<?= h($bp) ?>/logout.php" title="Salir">
          <i class="fas fa-sign-out-alt"></i>
        </a>
      </li>
    </ul>
  </nav>

  <!-- Sidebar -->
  <aside class="main-sidebar sidebar-dark-primary elevation-4">
    <a href="<?= h($bp) ?>/index.php" class="brand-link">
      <span class="brand-text font-weight-light pl-2"><?= h($cfg['app_name'] ?? 'Com Cobranzas') ?></span>
    </a>

    <div class="sidebar">
      <?php require $sidebar_file; ?>
    </div>
  </aside>

  <!-- Content -->
  <div class="content-wrapper">
    <div class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1 class="m-0"><?= h($page_title ?? 'Panel') ?></h1>
          </div>
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="<?= h($bp) ?>/index.php">Inicio</a></li>
              <li class="breadcrumb-item active"><?= h($page_title ?? 'Panel') ?></li>
            </ol>
          </div>
        </div>
      </div>
    </div>

    <section class="content">
      <div class="container-fluid">
