<?php
declare(strict_types=1);
require __DIR__ . '/../layouts/top.php';
?>
<div class="card">
  <div class="card-header">
    <h3 class="card-title">Registrar pago (Caso #<?= (int)$case['id'] ?>)</h3>
  </div>
  <div class="card-body">
    <?php if (!empty($err)): ?>
      <div class="alert alert-danger"><?= h($err) ?></div>
    <?php endif; ?>

    <form method="post" enctype="multipart/form-data">
      <?= csrf_field() ?>

      <div class="form-group">
        <label>Monto</label>
        <input type="number" step="0.01" min="0" name="amount" class="form-control" required>
      </div>

      <div class="form-group">
        <label>Fecha</label>
        <input type="date" name="payment_date" value="<?= h(date('Y-m-d')) ?>" class="form-control" required>
      </div>

      <div class="form-group">
        <label>Método</label>
        <select name="method" class="form-control">
          <option value="efectivo">Efectivo</option>
          <option value="transferencia">Transferencia</option>
          <option value="sinpe">SINPE</option>
          <option value="tarjeta">Tarjeta</option>
          <option value="otro">Otro</option>
        </select>
      </div>

      <div class="form-group">
        <label>Nota</label>
        <input type="text" name="note" class="form-control" placeholder="Ej: Pago parcial / comprobante #...">
      </div>

      <div class="form-group">
        <label>Comprobante (opcional)</label>
        <input type="file" name="attachment" class="form-control" accept="image/*,application/pdf">
        <small class="text-muted">Desde celular puedes usar cámara.</small>
      </div>

      <button class="btn btn-primary">
        <i class="fas fa-save mr-1"></i> Guardar
      </button>
    </form>
  </div>
</div>
<?php require __DIR__ . '/../layouts/bottom.php'; ?>
