<?php
declare(strict_types=1);
require __DIR__ . '/../layouts/top.php';

$bp = base_path();
$total_paid = PaymentModel::sumPaid((int)$case['id']);

$start = (string)($case['debt_start_date'] ?? '');
if ($start === '' || $start === '0000-00-00') $start = (string)$case['created_at'];

$interest = calc_interest((float)$case['amount'], $start);
$saldo = max(0, (float)$case['amount'] + $interest - $total_paid);
?>
<div class="card">
  <div class="card-header d-flex justify-content-between">
    <h3 class="card-title">Pagos del caso #<?= (int)$case['id'] ?></h3>
    <?php if (in_array($user['role'], ['admin','gestor'], true)): ?>
      <a class="btn btn-sm btn-primary"
         href="<?= h($bp) ?>/<?= h($user['role']) ?>/payment_add.php?case_id=<?= (int)$case['id'] ?>">
        <i class="fas fa-plus mr-1"></i> Registrar pago
      </a>
    <?php endif; ?>
  </div>

  <div class="card-body">
    <div class="row text-sm mb-3">
      <div class="col-md-4"><b>Monto:</b> <?= number_format((float)$case['amount'],2) ?></div>
      <div class="col-md-4"><b>Interés:</b> <?= number_format($interest,2) ?></div>
      <div class="col-md-4"><b>Saldo:</b> <?= number_format($saldo,2) ?></div>
    </div>

    <table class="table table-hover text-sm">
      <thead>
        <tr>
          <th>Fecha</th>
          <th>Monto</th>
          <th>Método</th>
          <th>Registrado por</th>
          <th>Comprobante</th>
        </tr>
      </thead>
      <tbody>
        <?php foreach ($payments as $p): ?>
          <tr>
            <td><?= h($p['payment_date']) ?></td>
            <td><?= number_format((float)$p['amount'],2) ?></td>
            <td><?= h($p['method']) ?></td>
            <td><?= h($p['created_by_name'] ?? '') ?></td>
            <td>
              <?php if (!empty($p['attachment_path'])): ?>
                <a class="btn btn-xs btn-outline-secondary" target="_blank"
                   href="<?= h($bp) ?>/payment_file.php?id=<?= (int)$p['id'] ?>">
                  Ver
                </a>
              <?php else: ?>
                <span class="text-muted">—</span>
              <?php endif; ?>
            </td>
          </tr>
        <?php endforeach; ?>
        <?php if (!$payments): ?>
          <tr><td colspan="5" class="text-center text-muted">Sin pagos</td></tr>
        <?php endif; ?>
      </tbody>
    </table>
  </div>
</div>
<?php require __DIR__ . '/../layouts/bottom.php'; ?>
