<?php
declare(strict_types=1);
require __DIR__ . '/../layouts/top.php';
?>
<div class="card">
  <div class="card-header">
    <h3 class="card-title">Nueva promesa (Caso #<?= (int)$case['id'] ?>)</h3>
  </div>
  <div class="card-body">
    <?php if (!empty($err)): ?><div class="alert alert-danger"><?= h($err) ?></div><?php endif; ?>

    <form method="post">
      <?= csrf_field() ?>
      <input type="hidden" name="case_id" value="<?= (int)$case['id'] ?>">

      <div class="form-group">
        <label>Monto prometido</label>
        <input class="form-control" type="number" step="0.01" min="0" name="promised_amount" required>
      </div>

      <div class="form-group">
        <label>Fecha prometida</label>
        <input class="form-control" type="date" name="promised_date" value="<?= h(date('Y-m-d')) ?>" required>
      </div>

      <div class="form-group">
        <label>Nota (opcional)</label>
        <input class="form-control" type="text" name="note" placeholder="Ej: promete pagar por SINPE">
      </div>

      <button class="btn btn-primary">
        <i class="fas fa-save mr-1"></i> Guardar promesa
      </button>
    </form>
  </div>
</div>
<?php require __DIR__ . '/../layouts/bottom.php'; ?>
