<?php
declare(strict_types=1);
require __DIR__ . '/../layouts/top.php';
$bp = base_path();
$isAdmin = ($user['role'] === 'admin');
?>
<div class="card">
  <div class="card-header d-flex justify-content-between">
    <h3 class="card-title">Promesas de pago</h3>
    <div class="text-muted text-sm">Listado (últimas 300)</div>
  </div>

  <div class="card-body table-responsive p-0">
    <table class="table table-hover text-sm mb-0">
      <thead>
        <tr>
          <th>ID</th>
          <th>Caso</th>
          <th>Deudor</th>
          <th>Fecha</th>
          <th>Monto</th>
          <th>Estado</th>
          <th></th>
        </tr>
      </thead>
      <tbody>
      <?php foreach (($items ?? []) as $p): ?>
        <?php
          $badge = 'badge-info';
          if ($p['status'] === 'active') $badge='badge-warning';
          if ($p['status'] === 'kept') $badge='badge-success';
          if ($p['status'] === 'broken') $badge='badge-danger';
          if ($p['status'] === 'cancelled') $badge='badge-secondary';
          $viewUrl = $bp . '/' . $user['role'] . '/promise_view.php?id=' . (int)$p['id'];
        ?>
        <tr>
          <td><?= (int)$p['id'] ?></td>
          <td>#<?= (int)$p['case_id'] ?></td>
          <td><?= h((string)($p['debtor_name'] ?? '')) ?> <span class="text-muted"> <?= h((string)($p['cedula'] ?? '')) ?></span></td>
          <td><?= h((string)$p['promised_date']) ?></td>
          <td><?= number_format((float)$p['promised_amount'], 2) ?></td>
          <td><span class="badge <?= $badge ?>"><?= h((string)$p['status']) ?></span></td>
          <td><a class="btn btn-xs btn-outline-secondary" href="<?= h($viewUrl) ?>">Ver</a></td>
        </tr>
      <?php endforeach; ?>

      <?php if (empty($items)): ?>
        <tr><td colspan="7" class="text-center text-muted p-3">Sin promesas</td></tr>
      <?php endif; ?>
      </tbody>
    </table>
  </div>
</div>
<?php require __DIR__ . '/../layouts/bottom.php'; ?>
