<?php
declare(strict_types=1);
require __DIR__ . '/../layouts/top.php';
?>
<div class="card">
  <div class="card-header">
    <h3 class="card-title">Mis promesas de pago</h3>
  </div>
  <div class="card-body table-responsive p-0">
    <table class="table table-hover text-sm mb-0">
      <thead>
        <tr>
          <th>Fecha</th>
          <th>Monto</th>
          <th>Estado</th>
        </tr>
      </thead>
      <tbody>
      <?php foreach (($items ?? []) as $p): ?>
        <tr>
          <td><?= h((string)$p['promised_date']) ?></td>
          <td><?= number_format((float)$p['promised_amount'], 2) ?></td>
          <td><?= h((string)$p['status']) ?></td>
        </tr>
      <?php endforeach; ?>
      <?php if (empty($items)): ?>
        <tr><td colspan="3" class="text-center text-muted p-3">Sin promesas registradas</td></tr>
      <?php endif; ?>
      </tbody>
    </table>
  </div>
</div>
<?php require __DIR__ . '/../layouts/bottom.php'; ?>
