<?php
declare(strict_types=1);
require __DIR__ . '/../layouts/top.php';

$badge = 'badge-info';
if ($p['status'] === 'active') $badge='badge-warning';
if ($p['status'] === 'kept') $badge='badge-success';
if ($p['status'] === 'broken') $badge='badge-danger';
if ($p['status'] === 'cancelled') $badge='badge-secondary';
?>
<div class="card">
  <div class="card-header d-flex justify-content-between">
    <h3 class="card-title">Promesa #<?= (int)$p['id'] ?> (Caso #<?= (int)$p['case_id'] ?>)</h3>
    <span class="badge <?= $badge ?>"><?= h((string)$p['status']) ?></span>
  </div>
  <div class="card-body">
    <p><b>Fecha prometida:</b> <?= h((string)$p['promised_date']) ?></p>
    <p><b>Monto:</b> <?= number_format((float)$p['promised_amount'],2) ?></p>
    <p><b>Nota:</b> <?= h((string)($p['note'] ?? '—')) ?></p>

    <?php if ($p['status'] === 'active' && in_array($user['role'], ['admin','gestor'], true)): ?>
      <hr>
      <form method="post">
        <?= csrf_field() ?>
        <div class="form-group">
          <label>Nota resolución (opcional)</label>
          <input class="form-control" name="resolve_note" placeholder="Ej: pagó hoy / no respondió">
        </div>
        <div class="btn-group">
          <button class="btn btn-success" name="action" value="kept"><i class="fas fa-check mr-1"></i>Cumplida</button>
          <button class="btn btn-danger" name="action" value="broken"><i class="fas fa-times mr-1"></i>Incumplida</button>
          <button class="btn btn-secondary" name="action" value="cancelled"><i class="fas fa-ban mr-1"></i>Cancelada</button>
        </div>
      </form>
    <?php endif; ?>
  </div>
</div>
<?php require __DIR__ . '/../layouts/bottom.php'; ?>
