<?php
// chat_file.php
declare(strict_types=1);

require_once __DIR__ . '/app/core/bootstrap.php';
require_once __DIR__ . '/app/models/CaseModel.php';

$user = require_login();

$att_id = (int)($_GET['att'] ?? 0);
if ($att_id <= 0) { http_response_code(400); exit('Bad request'); }

// Buscar adjunto + case_id
$st = db()->prepare("
  SELECT a.*, m.case_id
  FROM case_chat_attachments a
  JOIN case_chat_messages m ON m.id = a.message_id
  WHERE a.id = ?
  LIMIT 1
");
$st->execute([$att_id]);
$att = $st->fetch();
if (!$att) { http_response_code(404); exit('No encontrado'); }

$case_id = (int)$att['case_id'];

// Autorizar acceso según rol
$allowed = false;

if ($user['role'] === 'admin') {
  $allowed = true;
} elseif ($user['role'] === 'gestor') {
  $st2 = db()->prepare("
    SELECT 1
    FROM case_assignments
    WHERE case_id = ? AND gestor_user_id = ? AND unassigned_at IS NULL
    LIMIT 1
  ");
  $st2->execute([$case_id, (int)$user['id']]);
  $allowed = (bool)$st2->fetchColumn();
} else { // deudor
  $case = CaseModel::byDebtorUser((int)$user['id']);
  $allowed = $case && ((int)$case['id'] === $case_id);
}

if (!$allowed) { http_response_code(403); exit('No autorizado'); }

$path = (string)$att['file_path'];
$full = realpath(__DIR__ . '/' . ltrim($path, '/'));
if (!$full || !is_file($full)) { http_response_code(404); exit('Archivo no existe'); }

// Raíces permitidas (seguras)
$allowed_roots = [];
$r1 = realpath(__DIR__ . '/storage/uploads');
if ($r1) $allowed_roots[] = $r1;

$r2 = realpath(__DIR__ . '/storage/expedients');
if ($r2) $allowed_roots[] = $r2;

$ok = false;
foreach ($allowed_roots as $root) {
  if (strpos($full, $root) === 0) { $ok = true; break; }
}
if (!$ok) {
  http_response_code(403);
  exit('Ruta inválida');
}

$mime = (string)$att['mime_type'];
$name = (string)$att['file_name'];

header('Content-Type: ' . $mime);
header('Content-Disposition: inline; filename="' . rawurlencode($name) . '"');
header('Content-Length: ' . filesize($full));
readfile($full);
exit;
