<?php
declare(strict_types=1);

require_once __DIR__ . '/../app/core/bootstrap.php';
require_once __DIR__ . '/../app/models/CaseModel.php';
require_once __DIR__ . '/../app/models/ChatModel.php';

$user = require_role(['deudor']);

$case = CaseModel::byDebtorUser((int)$user['id']);
if (!$case) { http_response_code(404); exit('No hay caso asignado'); }

$case_id = (int)$case['id'];

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  csrf_verify();
  $text = (string)($_POST['message'] ?? '');
  $msg_id = ChatModel::addMessage($case_id, 'deudor', (int)$user['id'], $text);

  if (!empty($_FILES['files']) && is_array($_FILES['files']['name'])) {
    handle_chat_uploads($case_id, $msg_id, $_FILES['files']);
  }

  redirect_to('deudor/chat.php');
}

$page_title = 'Chat';
$active = 'chat';

$messages = ChatModel::listMessages($case_id, 80);
$msg_ids = array_map(fn($m) => (int)$m['id'], $messages);
$att_map = ChatModel::attachmentsForMessages($msg_ids);

require __DIR__ . '/../app/views/chat/case_chat.php';
