<?php
// expedient_file.php
declare(strict_types=1);

require_once __DIR__ . '/app/core/bootstrap.php';
require_once __DIR__ . '/app/models/CaseModel.php';
require_once __DIR__ . '/app/models/ExpedientModel.php';

$user = require_login();

$exp_id = (int)($_GET['id'] ?? 0);
if ($exp_id <= 0) { http_response_code(400); exit('Bad request'); }

$exp = ExpedientModel::find($exp_id);
if (!$exp) { http_response_code(404); exit('No encontrado'); }

$case_id = (int)$exp['case_id'];

// Autorizar por rol
$allowed = false;

if ($user['role'] === 'admin') {
  $allowed = true;
} elseif ($user['role'] === 'gestor') {
  $st = db()->prepare("
    SELECT 1 FROM case_assignments
    WHERE case_id=? AND gestor_user_id=? AND unassigned_at IS NULL
    LIMIT 1
  ");
  $st->execute([$case_id, (int)$user['id']]);
  $allowed = (bool)$st->fetchColumn();
} else { // deudor
  $allowed = ((int)$exp['debtor_user_id'] === (int)$user['id']);
}

if (!$allowed) { http_response_code(403); exit('No autorizado'); }

$rel = (string)$exp['pdf_path'];
$full = realpath(__DIR__ . '/' . ltrim($rel, '/'));
if (!$full || !is_file($full)) { http_response_code(404); exit('Archivo no existe'); }

// Debe estar dentro de storage/expedients
$root = realpath(__DIR__ . '/storage/expedients');
if (!$root || strpos($full, $root) !== 0) { http_response_code(403); exit('Ruta inválida'); }

header('Content-Type: application/pdf');
header('Content-Disposition: inline; filename="expediente_'.$exp_id.'.pdf"');
header('Content-Length: ' . filesize($full));
readfile($full);
exit;
