<?php
declare(strict_types=1);

require_once __DIR__ . '/../app/core/bootstrap.php';
require_once __DIR__ . '/../app/models/CaseModel.php';
require_once __DIR__ . '/../app/models/ChatModel.php';

$user = require_role(['gestor']);

$case_id = (int)($_GET['id'] ?? 0);
$case = CaseModel::find($case_id);
if (!$case) { http_response_code(404); exit('Caso no encontrado'); }

// Validar asignación activa
$st = db()->prepare("
  SELECT 1 FROM case_assignments
  WHERE case_id=? AND gestor_user_id=? AND unassigned_at IS NULL
  LIMIT 1
");
$st->execute([$case_id, (int)$user['id']]);
if (!$st->fetchColumn()) { http_response_code(403); exit('No autorizado'); }

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  csrf_verify();
  $text = (string)($_POST['message'] ?? '');
  $msg_id = ChatModel::addMessage($case_id, 'gestor', (int)$user['id'], $text);

  if (!empty($_FILES['files']) && is_array($_FILES['files']['name'])) {
    handle_chat_uploads($case_id, $msg_id, $_FILES['files']);
  }

  redirect_to('gestor/case_chat.php?id=' . $case_id);
}

$page_title = 'Chat Caso #' . $case_id;
$active = 'cases';

$messages = ChatModel::listMessages($case_id, 80);
$msg_ids = array_map(fn($m) => (int)$m['id'], $messages);
$att_map = ChatModel::attachmentsForMessages($msg_ids);

require __DIR__ . '/../app/views/chat/case_chat.php';
