<?php
declare(strict_types=1);
require_once __DIR__ . '/../app/core/bootstrap.php';
require_once __DIR__ . '/../app/models/CaseModel.php';

$user = require_role(['gestor']);

$id = (int)($_GET['id'] ?? 0);
$case = CaseModel::find($id);

if (!$case) {
  http_response_code(404);
  exit('Caso no encontrado');
}

/**
 * Validar que el caso pertenece al gestor (seguridad)
 */
$myCases = CaseModel::byGestor((int)$user['id']);
$allowed = false;
foreach ($myCases as $c) {
  if ((int)$c['id'] === (int)$case['id']) { $allowed = true; break; }
}
if (!$allowed) {
  http_response_code(403);
  exit('No autorizado.');
}

$page_title = 'Caso #' . $case['id'];
$active = 'cases';

require __DIR__ . '/../app/views/gestor/case_view.php';
