<?php
declare(strict_types=1);

require_once __DIR__ . '/../app/core/bootstrap.php';
require_once __DIR__ . '/../app/models/CaseModel.php';

$user = require_role(['gestor']);

$case_id = (int)($_GET['case_id'] ?? 0);
$case = CaseModel::find($case_id);
if (!$case) { http_response_code(404); exit('Caso no encontrado'); }

// validar asignación
$st = db()->prepare("
  SELECT 1 FROM case_assignments
  WHERE case_id=? AND gestor_user_id=? AND unassigned_at IS NULL
  LIMIT 1
");
$st->execute([$case_id, (int)$user['id']]);
if (!$st->fetchColumn()) { http_response_code(403); exit('No autorizado'); }

$page_title = 'Nuevo expediente - Caso #' . $case_id;
$active = 'cases';

require __DIR__ . '/../app/views/expedients/upload.php';
