<?php
declare(strict_types=1);
require_once __DIR__ . '/../app/core/bootstrap.php';
require_once __DIR__ . '/../app/models/CaseModel.php';
require_once __DIR__ . '/../app/models/PaymentModel.php';

$user = require_role(['gestor']);
$case_id = (int)($_GET['case_id'] ?? 0);
$case = CaseModel::find($case_id);
if (!$case) exit('Caso no encontrado');

$st = db()->prepare("SELECT 1 FROM case_assignments WHERE case_id=? AND gestor_user_id=? AND unassigned_at IS NULL");
$st->execute([$case_id, (int)$user['id']]);
if (!$st->fetchColumn()) exit('No autorizado');

$page_title = 'Pagos - Caso #' . $case_id;
$active = 'cases';

$payments = PaymentModel::listByCase($case_id);
require __DIR__ . '/../app/views/payments/list.php';
