<?php
declare(strict_types=1);

require_once __DIR__ . '/../app/core/bootstrap.php';
require_once __DIR__ . '/../app/models/CaseModel.php';
require_once __DIR__ . '/../app/models/PromiseModel.php';
require_once __DIR__ . '/../app/models/NotificationModel.php';

$user = require_role(['gestor']);

$case_id = (int)($_GET['case_id'] ?? $_POST['case_id'] ?? 0);
$case = $case_id ? CaseModel::find($case_id) : null;
if (!$case) { http_response_code(404); exit('Caso no encontrado'); }

// validar asignación
$st = db()->prepare("SELECT 1 FROM case_assignments WHERE case_id=? AND gestor_user_id=? AND unassigned_at IS NULL");
$st->execute([$case_id, (int)$user['id']]);
if (!$st->fetchColumn()) { http_response_code(403); exit('No autorizado'); }

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  csrf_verify();

  $amt = (float)($_POST['promised_amount'] ?? 0);
  $date = (string)($_POST['promised_date'] ?? '');
  $note = trim((string)($_POST['note'] ?? ''));

  if ($amt <= 0 || $date === '') {
    $err = 'Monto/Fecha inválidos';
  } else {
    $pid = PromiseModel::create([
      'case_id' => $case_id,
      'promised_amount' => $amt,
      'promised_date' => $date,
      'note' => $note ?: null,
      'created_by' => (int)$user['id'],
      'created_role' => 'gestor',
    ]);

    $bp = base_path();
    // notificar admin principal (busca primer admin)
    $aid = (int)(db()->query("SELECT id FROM users WHERE role='admin' ORDER BY id ASC LIMIT 1")->fetchColumn() ?: 0);
    if ($aid > 0) {
      NotificationModel::add($aid, "Nueva promesa (#{$pid})", "Gestor: {$user['name']} | Caso #{$case_id} para {$date}", $bp.'/admin/promise_view.php?id='.$pid, 'info');
    }
    NotificationModel::add((int)$user['id'], "Nueva promesa (#{$pid})", "Caso #{$case_id} para {$date}", $bp.'/gestor/promise_view.php?id='.$pid, 'info');

    redirect_to('gestor/promise_view.php?id=' . $pid);
  }
}

$page_title = 'Nueva promesa';
$active = 'promises';

require __DIR__ . '/../app/views/promises/form.php';
