<?php
declare(strict_types=1);

require_once __DIR__ . '/../app/core/bootstrap.php';
require_once __DIR__ . '/../app/models/PromiseModel.php';
require_once __DIR__ . '/../app/models/NotificationModel.php';

$user = require_role(['gestor']);

$id = (int)($_GET['id'] ?? 0);
$p = PromiseModel::find($id);
if (!$p) { http_response_code(404); exit('No existe'); }

// validar que el caso pertenezca al gestor
$st = db()->prepare("
  SELECT 1 FROM case_assignments
  WHERE case_id=? AND gestor_user_id=? AND unassigned_at IS NULL
");
$st->execute([(int)$p['case_id'], (int)$user['id']]);
if (!$st->fetchColumn()) { http_response_code(403); exit('No autorizado'); }

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  csrf_verify();
  $action = (string)($_POST['action'] ?? '');
  $note = trim((string)($_POST['resolve_note'] ?? ''));

  if (in_array($action, ['kept','broken','cancelled'], true)) {
    PromiseModel::resolve($id, $action, (int)$user['id'], $note ?: null);

    $bp = base_path();
    NotificationModel::add((int)$user['id'], "Promesa #{$id} actualizada", "Estado: {$action}", $bp.'/gestor/promise_view.php?id='.$id, 'success');

    // notificar admin principal
    $aid = (int)(db()->query("SELECT id FROM users WHERE role='admin' ORDER BY id ASC LIMIT 1")->fetchColumn() ?: 0);
    if ($aid > 0) {
      NotificationModel::add($aid, "Promesa #{$id} actualizada", "Gestor: {$user['name']} | Estado: {$action}", $bp.'/admin/promise_view.php?id='.$id, 'success');
    }

    redirect_to('gestor/promise_view.php?id=' . $id);
  }
}

$page_title = 'Ver promesa';
$active = 'promises';

require __DIR__ . '/../app/views/promises/view.php';
