<?php
declare(strict_types=1);

require_once __DIR__ . '/../app/core/bootstrap.php';
$user = require_role(['gestor']);

$page_title = 'Mis promesas';
$active = 'promises';

$st = db()->prepare("
  SELECT p.*, c.debtor_name, c.cedula
  FROM case_promises p
  JOIN cases c ON c.id=p.case_id
  JOIN case_assignments a ON a.case_id=c.id AND a.unassigned_at IS NULL
  WHERE a.gestor_user_id=?
  ORDER BY p.id DESC
  LIMIT 300
");
$st->execute([(int)$user['id']]);
$items = $st->fetchAll(PDO::FETCH_ASSOC) ?: [];

require __DIR__ . '/../app/views/promises/list.php';
