<?php
// login.php
declare(strict_types=1);

require_once __DIR__ . '/app/core/bootstrap.php';
$cfg = require __DIR__ . '/app/config/config.php';

$err = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  csrf_verify();
  $id = (string)($_POST['identifier'] ?? '');
  $pw = (string)($_POST['password'] ?? '');

  $u = login_attempt($id, $pw);
  if ($u) {
    redirect_to('index.php');
  }
  $err = 'Credenciales inválidas.';
}
?>
<!doctype html>
<html lang="es">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title><?= h($cfg['app_name']) ?> - Login</title>
  <link rel="stylesheet" href="assets/app.css">
</head>
<body class="login-page">
  <div class="login-box">
    <h1><?= h($cfg['app_name']) ?></h1>

    <?php if ($err): ?>
      <div class="alert"><?= h($err) ?></div>
    <?php endif; ?>

    <form method="post" autocomplete="on">
      <?= csrf_field() ?>
      <label>Correo (Admin/Gestor) o Cédula (Deudor)</label>
      <input name="identifier" type="text" required>

      <label>Clave</label>
      <input name="password" type="password" required>

      <button type="submit">Ingresar</button>
    </form>

    <p class="hint">
      Admin/Gestor: email + clave. Deudor: cédula + clave (creada por su gestor).
    </p>
  </div>
</body>
</html>
