<?php
declare(strict_types=1);

require_once __DIR__ . '/app/core/bootstrap.php';
require_once __DIR__ . '/app/models/CaseModel.php';
require_once __DIR__ . '/app/models/PaymentModel.php';

$user = require_login();

$pid = (int)($_GET['id'] ?? 0);
if ($pid <= 0) { http_response_code(400); exit('Bad request'); }

$st = db()->prepare("SELECT * FROM case_payments WHERE id=? LIMIT 1");
$st->execute([$pid]);
$p = $st->fetch();
if (!$p) { http_response_code(404); exit('No encontrado'); }

$case_id = (int)$p['case_id'];
$path = (string)($p['attachment_path'] ?? '');
if ($path === '') { http_response_code(404); exit('Sin adjunto'); }

// Autorizar acceso
$allowed = false;
if ($user['role'] === 'admin') {
  $allowed = true;
} elseif ($user['role'] === 'gestor') {
  $st2 = db()->prepare("
    SELECT 1 FROM case_assignments
    WHERE case_id=? AND gestor_user_id=? AND unassigned_at IS NULL
    LIMIT 1
  ");
  $st2->execute([$case_id, (int)$user['id']]);
  $allowed = (bool)$st2->fetchColumn();
} else { // deudor
  $case = CaseModel::byDebtorUser((int)$user['id']);
  $allowed = $case && ((int)$case['id'] === $case_id);
}

if (!$allowed) { http_response_code(403); exit('No autorizado'); }

$full = realpath(__DIR__ . '/' . ltrim($path, '/'));
if (!$full || !is_file($full)) { http_response_code(404); exit('Archivo no existe'); }

$root = realpath(__DIR__ . '/storage/uploads/payments');
if (!$root || strpos($full, $root) !== 0) { http_response_code(403); exit('Ruta inválida'); }

$mime = 'application/octet-stream';
$finfo = finfo_open(FILEINFO_MIME_TYPE);
if ($finfo) { $mime = (string)finfo_file($finfo, $full); finfo_close($finfo); }

header('Content-Type: ' . $mime);
header('Content-Disposition: inline; filename="comprobante_'.$pid.'"');
header('Content-Length: ' . filesize($full));
readfile($full);
exit;
