<?php
declare(strict_types=1);

require_once __DIR__ . '/app/core/bootstrap.php';
require_once __DIR__ . '/app/models/NotificationModel.php';
require_once __DIR__ . '/app/models/PromiseModel.php';

$user = require_role(['admin']); // solo admin ejecuta tick (seguro)

$bp = base_path();

// 1) marcar vencidas (auto) si quieres (0 días de gracia)
$broken = PromiseModel::markBrokenOverdue(0);

// 2) detectar promesas activas por vencer (0-2 días)
$st = db()->query("
  SELECT p.id, p.case_id, p.promised_amount, p.promised_date,
         a.gestor_user_id
  FROM case_promises p
  LEFT JOIN case_assignments a ON a.case_id=p.case_id AND a.unassigned_at IS NULL
  WHERE p.status='active'
    AND p.promised_date BETWEEN CURDATE() AND DATE_ADD(CURDATE(), INTERVAL 2 DAY)
");
$dueSoon = $st ? ($st->fetchAll(PDO::FETCH_ASSOC) ?: []) : [];

foreach ($dueSoon as $r) {
  $pid = (int)$r['id'];
  $case_id = (int)$r['case_id'];
  $gestor_id = (int)($r['gestor_user_id'] ?? 0);
  $date = (string)$r['promised_date'];

  $title = "Promesa por vencer (#{$pid})";
  $body  = "Caso #{$case_id} vence {$date} por " . number_format((float)$r['promised_amount'], 2);
  $url   = $bp . '/admin/promise_view.php?id=' . $pid;

  // notificar admin global (a ti)
  NotificationModel::add((int)$user['id'], $title, $body, $url, 'warn');

  // notificar gestor asignado
  if ($gestor_id > 0) {
    NotificationModel::add($gestor_id, $title, $body, $bp . '/gestor/promise_view.php?id=' . $pid, 'warn');
  }
}

// 3) detectar activas vencidas (ayer o antes) para notificar danger
$st = db()->query("
  SELECT p.id, p.case_id, p.promised_amount, p.promised_date,
         a.gestor_user_id
  FROM case_promises p
  LEFT JOIN case_assignments a ON a.case_id=p.case_id AND a.unassigned_at IS NULL
  WHERE p.status='active'
    AND p.promised_date < CURDATE()
  ORDER BY p.promised_date ASC
  LIMIT 200
");
$over = $st ? ($st->fetchAll(PDO::FETCH_ASSOC) ?: []) : [];

foreach ($over as $r) {
  $pid = (int)$r['id'];
  $case_id = (int)$r['case_id'];
  $gestor_id = (int)($r['gestor_user_id'] ?? 0);
  $date = (string)$r['promised_date'];

  $title = "Promesa vencida (#{$pid})";
  $body  = "Caso #{$case_id} venció {$date} por " . number_format((float)$r['promised_amount'], 2);
  $url   = $bp . '/admin/promise_view.php?id=' . $pid;

  NotificationModel::add((int)$user['id'], $title, $body, $url, 'danger');
  if ($gestor_id > 0) {
    NotificationModel::add($gestor_id, $title, $body, $bp . '/gestor/promise_view.php?id=' . $pid, 'danger');
  }
}

echo "OK tick_promises. broken_auto={$broken} dueSoon=" . count($dueSoon) . " overdue=" . count($over);
